"""empty message

Revision ID: fb91cb51ba69
Revises: e5f6be8a7b28
Create Date: 2017-01-16 09:12:55.543085

"""

# revision identifiers, used by Alembic.
revision = 'fb91cb51ba69'
down_revision = 'e5f6be8a7b28'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tb_contact',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=True),
    sa.Column('email', sa.String(length=256), nullable=True),
    sa.Column('description', sa.String(length=512), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_contact')),
    sa.UniqueConstraint('username', name=op.f('uq_tb_contact_username'))
    )
    op.create_table('tb_mail_alert_instance',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('alert_id', sa.Integer(), nullable=True),
    sa.Column('triggered_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('alert_data', postgresql.JSON(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_mail_alert_instance'))
    )
    op.create_table('tb_mail_alert_rule',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('alert_id', sa.Integer(), nullable=False),
    sa.Column('enabled', sa.Integer(), nullable=False),
    sa.Column('alert_level', sa.Integer(), nullable=False),
    sa.Column('alert_type', sa.Integer(), nullable=False),
    sa.Column('frequency', postgresql.JSON(), nullable=True),
    sa.Column('send_to_all', sa.Integer(), nullable=False),
    sa.Column('extra_setting', postgresql.JSON(), nullable=True),
    sa.Column('recipients', postgresql.JSON(), nullable=True),
    sa.Column('subject', sa.String(), nullable=True),
    sa.Column('message', sa.String(), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_mail_alert_rule')),
    sa.UniqueConstraint('alert_id', name=op.f('uq_tb_mail_alert_rule_alert_id'))
    )
    op.create_table('tb_mail_outbox',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('alert_id', sa.Integer(), nullable=True),
    sa.Column('alert_level', sa.Integer(), nullable=False),
    sa.Column('recipients', postgresql.JSON(), nullable=True),
    sa.Column('subject', sa.String(), nullable=True),
    sa.Column('message', sa.String(), nullable=True),
    sa.Column('triggered_time_in_utc', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_mail_outbox'))
    )
    op.drop_constraint(u'uq_tb_global_alerts_alert_id_alert_state_instance_id', 'tb_global_alerts', type_='unique')
    op.create_unique_constraint(op.f('uq_tb_global_alerts_alert_id'), 'tb_global_alerts', ['alert_id', 'alert_state', 'instance_id'])
    op.alter_column(u'tb_users', 'email',
               existing_type=sa.VARCHAR(),
               type_=sa.String(length=256),
               existing_nullable=True)
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(u'tb_users', 'email',
               existing_type=sa.String(length=256),
               type_=sa.VARCHAR(),
               existing_nullable=True)
    op.drop_constraint(op.f('uq_tb_global_alerts_alert_id'), 'tb_global_alerts', type_='unique')
    op.create_unique_constraint(u'uq_tb_global_alerts_alert_id_alert_state_instance_id', 'tb_global_alerts', ['alert_id', 'alert_state', 'instance_id'])
    op.drop_table('tb_mail_outbox')
    op.drop_table('tb_mail_alert_rule')
    op.drop_table('tb_mail_alert_instance')
    op.drop_table('tb_contact')
    ### end Alembic commands ###
